const mysql = require('mysql2/promise');
const bcrypt = require('bcrypt');

async function setAllPasswords() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'vtravel_local'
  });

  try {
    console.log('Setting passwords for all users...\n');

    // Hash passwords
    const vamosPwd = await bcrypt.hash('34Vamos2025.', 10);
    const milaPwd = await bcrypt.hash('34Mila2025.', 10);

    // Set Vamos password
    await connection.execute(`
      UPDATE agency_users
      SET password = ?
      WHERE email = 'yetkili@vamos.ist'
    `, [vamosPwd]);
    console.log('✅ yetkili@vamos.ist -> 34Vamos2025.');

    // Set Mila passwords for all others
    await connection.execute(`
      UPDATE agency_users
      SET password = ?
      WHERE email != 'yetkili@vamos.ist'
    `, [milaPwd]);
    console.log('✅ All other users -> 34Mila2025.\n');

    // Verify and display
    const [users] = await connection.execute(`
      SELECT
        CONCAT(first_name, ' ', last_name) as name,
        email,
        CASE
          WHEN password IS NOT NULL THEN 'Set'
          ELSE 'Not Set'
        END as password_status
      FROM agency_users
      ORDER BY email
    `);

    console.log('User password status:\n');
    console.log('Name                      | Email                          | Password | Credentials');
    console.log('--------------------------|--------------------------------|----------|------------------');
    users.forEach(user => {
      const pwd = user.email === 'yetkili@vamos.ist' ? '34Vamos2025.' : '34Mila2025.';
      const status = user.password_status === 'Set' ? '✅' : '❌';
      console.log(`${user.name.padEnd(25)} | ${user.email.padEnd(30)} | ${status}       | ${pwd}`);
    });

    console.log('\n✅ All passwords set successfully!');

  } catch (error) {
    console.error('❌ Error:', error.message);
    throw error;
  } finally {
    await connection.end();
  }
}

setAllPasswords();
