import React from 'react';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui';
import { 
  TrendingUp, 
  Users, 
  CheckCircle, 
  Clock 
} from 'lucide-react';
import type { DashboardStats } from '@/types';

interface StatsCardsProps {
  stats: DashboardStats;
}

export default function StatsCards({ stats }: StatsCardsProps) {
  const cards = [
    {
      title: 'Bekleyen Talepler',
      value: stats.pendingRequests,
      icon: Clock,
      change: '+5',
      changeType: 'positive' as const,
      subtitle: `${stats.totalTicketRequests} toplam talep`,
    },
    {
      title: 'Bugün Biletlenen',
      value: stats.ticketedToday,
      icon: CheckCircle,
      change: '+8',
      changeType: 'positive' as const,
      subtitle: `${stats.todayScheduled} check-in planlandı`,
    },
    {
      title: 'Check-in Başarı Oranı',
      value: `${stats.successRate}%`,
      icon: TrendingUp,
      change: '+2.4%',
      changeType: 'positive' as const,
      subtitle: 'Son 7 gün',
    },
    {
      title: 'Yaklaşan Uçuşlar',
      value: stats.upcomingFlights,
      icon: Users,
      change: '+12',
      changeType: 'positive' as const,
      subtitle: `${stats.failedCheckIns} başarısız check-in`,
    },
  ];

  return (
    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
      {cards.map((card, index) => (
        <Card key={index}>
          <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
            <CardTitle className="text-sm font-medium text-gray-600">
              {card.title}
            </CardTitle>
            <card.icon className="h-4 w-4 text-gray-400" />
          </CardHeader>
          <CardContent>
            <div className="text-2xl font-bold text-gray-900">
              {card.value}
            </div>
            <p className="text-xs text-gray-500 mb-1">
              {card.subtitle}
            </p>
            <p className={`text-xs ${
              card.changeType === 'positive' 
                ? 'text-green-600' 
                : 'text-red-600'
            }`}>
              {card.change} geçen haftadan
            </p>
          </CardContent>
        </Card>
      ))}
    </div>
  );
}