import type { AgencyPermission } from '@/types';

export interface PermissionCategory {
  name: string;
  label: string;
  permissions: {
    value: AgencyPermission;
    label: string;
    description?: string;
  }[];
}

export const PERMISSION_CATEGORIES: PermissionCategory[] = [
  {
    name: 'tickets',
    label: 'Bilet İşlemleri',
    permissions: [
      { value: 'tickets_view_all', label: 'Tüm Biletleri Görüntüle', description: 'Tüm bilet taleplerini görüntüleyebilir' },
      { value: 'tickets_view_own', label: 'Kendi Biletlerini Görüntüle', description: 'Sadece kendi oluşturduğu biletleri görür' },
      { value: 'tickets_create', label: 'Bilet Oluştur', description: 'Yeni bilet talebi oluşturabilir' },
      { value: 'tickets_edit', label: 'Bilet Düzenle', description: 'Mevcut biletleri düzenleyebilir' },
      { value: 'tickets_delete', label: 'Bilet Sil', description: 'Bilet taleplerini silebilir' },
      { value: 'tickets_approve', label: 'Bilet Onayla', description: 'Bilet taleplerini onaylayabilir' },
      { value: 'tickets_issue', label: 'Bilet Kesme', description: 'Bilet kesme işlemi yapabilir' },
    ]
  },
  {
    name: 'checkin',
    label: 'Check-in İşlemleri',
    permissions: [
      { value: 'checkin_view_all', label: 'Tüm Check-in\'leri Görüntüle', description: 'Tüm check-in işlemlerini görür' },
      { value: 'checkin_view_own', label: 'Kendi Check-in\'lerini Görüntüle', description: 'Sadece kendi check-in işlemlerini görür' },
      { value: 'checkin_manage', label: 'Check-in Yönet', description: 'Check-in işlemlerini yönetebilir' },
      { value: 'checkin_retry', label: 'Check-in Tekrar Dene', description: 'Başarısız check-in\'leri tekrar deneyebilir' },
    ]
  },
  {
    name: 'accommodation',
    label: 'Konaklama İşlemleri',
    permissions: [
      { value: 'accommodation_view_all', label: 'Tüm Konaklamaları Görüntüle' },
      { value: 'accommodation_view_own', label: 'Kendi Konaklama Taleplerini Görüntüle' },
      { value: 'accommodation_create', label: 'Konaklama Talebi Oluştur' },
      { value: 'accommodation_edit', label: 'Konaklama Düzenle' },
      { value: 'accommodation_delete', label: 'Konaklama Sil' },
      { value: 'accommodation_quote', label: 'Fiyat Teklifi Ver' },
      { value: 'accommodation_book', label: 'Rezervasyon Yap' },
    ]
  },
  {
    name: 'visa',
    label: 'Vize İşlemleri',
    permissions: [
      { value: 'visa_view_all', label: 'Tüm Vize Başvurularını Görüntüle' },
      { value: 'visa_view_own', label: 'Kendi Vize Başvurularını Görüntüle' },
      { value: 'visa_create', label: 'Vize Başvurusu Oluştur' },
      { value: 'visa_edit', label: 'Vize Başvurusu Düzenle' },
      { value: 'visa_delete', label: 'Vize Başvurusu Sil' },
      { value: 'visa_approve', label: 'Vize Başvurusu Onayla' },
      { value: 'visa_documents', label: 'Belge Yönetimi' },
    ]
  },
  {
    name: 'transfer',
    label: 'Transfer İşlemleri',
    permissions: [
      { value: 'transfer_view_all', label: 'Tüm Transferleri Görüntüle' },
      { value: 'transfer_view_own', label: 'Kendi Transfer Taleplerini Görüntüle' },
      { value: 'transfer_create', label: 'Transfer Talebi Oluştur' },
      { value: 'transfer_edit', label: 'Transfer Düzenle' },
      { value: 'transfer_delete', label: 'Transfer Sil' },
      { value: 'transfer_assign', label: 'Şoför Ata' },
      { value: 'transfer_track', label: 'Transfer Takip' },
    ]
  },
  {
    name: 'customers',
    label: 'Müşteri Yönetimi',
    permissions: [
      { value: 'customers_view_all', label: 'Tüm Müşterileri Görüntüle' },
      { value: 'customers_view_own', label: 'Kendi Müşterilerini Görüntüle' },
      { value: 'customers_create', label: 'Müşteri Oluştur' },
      { value: 'customers_edit', label: 'Müşteri Düzenle' },
      { value: 'customers_delete', label: 'Müşteri Sil' },
      { value: 'customers_export', label: 'Müşteri Dışa Aktar' },
    ]
  },
  {
    name: 'accounting',
    label: 'Muhasebe',
    permissions: [
      { value: 'accounting_view_all', label: 'Tüm Muhasebe Kayıtlarını Görüntüle' },
      { value: 'accounting_view_own', label: 'Kendi Muhasebe Kayıtlarını Görüntüle' },
      { value: 'accounting_create', label: 'Muhasebe Kaydı Oluştur' },
      { value: 'accounting_edit', label: 'Muhasebe Kaydı Düzenle' },
      { value: 'accounting_invoice', label: 'Faturalama' },
      { value: 'accounting_payment', label: 'Ödeme İşlemleri' },
      { value: 'accounting_reports', label: 'Mali Raporlar' },
    ]
  },
  {
    name: 'users',
    label: 'Kullanıcı Yönetimi',
    permissions: [
      { value: 'users_view_all', label: 'Tüm Kullanıcıları Görüntüle' },
      { value: 'users_create', label: 'Kullanıcı Oluştur' },
      { value: 'users_edit', label: 'Kullanıcı Düzenle' },
      { value: 'users_delete', label: 'Kullanıcı Sil' },
      { value: 'users_permissions', label: 'Yetki Yönetimi' },
    ]
  },
  {
    name: 'departments',
    label: 'Departman Yönetimi',
    permissions: [
      { value: 'departments_view', label: 'Departmanları Görüntüle' },
      { value: 'departments_create', label: 'Departman Oluştur' },
      { value: 'departments_edit', label: 'Departman Düzenle' },
      { value: 'departments_delete', label: 'Departman Sil' },
    ]
  },
  {
    name: 'reports',
    label: 'Raporlar',
    permissions: [
      { value: 'reports_view', label: 'Raporları Görüntüle' },
      { value: 'reports_export', label: 'Rapor Dışa Aktar' },
      { value: 'reports_advanced', label: 'Gelişmiş Raporlar' },
    ]
  },
  {
    name: 'settings',
    label: 'Sistem Ayarları',
    permissions: [
      { value: 'settings_view', label: 'Ayarları Görüntüle' },
      { value: 'settings_edit', label: 'Ayarları Düzenle' },
      { value: 'settings_system', label: 'Sistem Ayarları' },
    ]
  },
];

// Departman türlerine göre önceden tanımlanmış yetki şablonları
export const DEPARTMENT_PERMISSION_TEMPLATES: Record<string, AgencyPermission[]> = {
  'Biletleme': [
    'tickets_view_all',
    'tickets_create',
    'tickets_edit',
    'tickets_issue',
    'checkin_view_all',
    'checkin_manage',
    'checkin_retry',
    'customers_view_all',
    'customers_create',
    'customers_edit',
  ],
  'Konaklama': [
    'accommodation_view_all',
    'accommodation_create',
    'accommodation_edit',
    'accommodation_quote',
    'accommodation_book',
    'customers_view_all',
    'customers_create',
    'customers_edit',
  ],
  'Vize': [
    'visa_view_all',
    'visa_create',
    'visa_edit',
    'visa_approve',
    'visa_documents',
    'customers_view_all',
    'customers_create',
    'customers_edit',
  ],
  'Transfer': [
    'transfer_view_all',
    'transfer_create',
    'transfer_edit',
    'transfer_assign',
    'transfer_track',
    'customers_view_all',
    'customers_create',
  ],
  'Muhasebe': [
    'accounting_view_all',
    'accounting_create',
    'accounting_edit',
    'accounting_invoice',
    'accounting_payment',
    'accounting_reports',
    'customers_view_all',
    'reports_view',
    'reports_export',
  ],
  'İK': [
    'users_view_all',
    'users_create',
    'users_edit',
    'users_permissions',
    'departments_view',
    'departments_create',
    'departments_edit',
    'reports_view',
  ],
};

// Yetki şablonu uygula
export function applyPermissionTemplate(departmentName: string): AgencyPermission[] {
  // Departman adında anahtar kelime ara
  for (const [key, permissions] of Object.entries(DEPARTMENT_PERMISSION_TEMPLATES)) {
    if (departmentName.toLowerCase().includes(key.toLowerCase())) {
      return permissions;
    }
  }

  // Varsayılan yetkiler
  return ['customers_view_own'];
}
